using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;


namespace VerticalLabel
{
    [ToolboxBitmap(typeof(VerticalLabel), "Varticallabel.ico")]

    public partial class VerticalLabel : System.Windows.Forms.Control
    {
        private string labelText;
        public enum OrientationStyle {UpToDown, DownToUp};
        private OrientationStyle orientation;

        public VerticalLabel()
        {
            InitializeComponent();
        }

        /// <summary> 
        /// Required designer variable.
        /// </summary>
        private System.ComponentModel.IContainer components = null;

        /// <summary> 
        /// Clean up any resources being used.
        /// </summary>
        /// <param name="disposing">true if managed resources should be disposed; otherwise, false.</param>
        protected override void Dispose(bool disposing)
        {
            if (disposing && (components != null))
            {
                components.Dispose();
            }
            base.Dispose(disposing);
        }

        [System.Diagnostics.DebuggerStepThrough()]
        private void InitializeComponent()
        {
            this.Size = new System.Drawing.Size(17, 100);
            this.orientation = OrientationStyle.UpToDown;
        }

        protected override void OnPaint(System.Windows.Forms.PaintEventArgs e)
        {
            float sngControlWidth;
            float sngControlHeight;
            float sngTransformX;
            float sngTransformY;
            Pen labelBorderPen = new Pen(this.ForeColor, 0);
            SolidBrush labelBackColorBrush = new SolidBrush(this.BackColor);
            SolidBrush labelForeColorBrush = new SolidBrush(this.ForeColor);
            base.OnPaint(e);
            sngControlWidth = this.Size.Width;
            sngControlHeight = this.Size.Height;
            e.Graphics.DrawRectangle(labelBorderPen, 0, 0, sngControlWidth, sngControlHeight);
            e.Graphics.FillRectangle(labelBackColorBrush, 0, 0, sngControlWidth, sngControlHeight);
            sngTransformX = 0;
            sngTransformY = sngControlHeight;
            e.Graphics.TranslateTransform(sngTransformX, sngTransformY);
            if (this.orientation == OrientationStyle.DownToUp)
            {
                e.Graphics.RotateTransform(270);
                e.Graphics.DrawString(labelText, this.Font, labelForeColorBrush, 0, 0);
            }
            else {
                e.Graphics.RotateTransform(90);
                e.Graphics.DrawString(labelText, this.Font, labelForeColorBrush, -e.Graphics.MeasureString(labelText, this.Font).Width, -e.Graphics.MeasureString(labelText, this.Font).Height);
            }
        }

        private void VTextBox_Resize(object sender, System.EventArgs e)
        {
            Invalidate();
        }

        [Category("Verticallabel"), Description("Text is displayed vertically in container")]
        public override string Text
        {
            get
            {
                return this.labelText;
            }
            set
            {
                this.labelText = value;
                Invalidate();
            }
        }

        public OrientationStyle Orientation
        {
            get
            {
                return this.orientation;
            }
            set
            {
                this.orientation = value;
                Invalidate();
            }
        }

    }

}
